STRINGS.ITEMS =
{
	RARITY =
	{
		COMMON = "Scuffed",
		UNCOMMON = "Ordinary",
		RARE = "DEV_UNUSED",
		EPIC = "Great",
		LEGENDARY = "Pristine",
		TITAN = "Masterwork",
		SET = "Set"
	},

	RARITY_CAPS =
	{
		COMMON = "SCUFFED",
		UNCOMMON = "ORDINARY",
		RARE = "DEV_UNUSED",
		EPIC = "GREAT",
		LEGENDARY = "PRISTINE",
		TITAN = "MASTERWORK",
		SET = "SET",
	},

	WEAPON = {
		hammer_basic =
		{
			name = "Crumbling Bammer",
			desc = "A heavy hitter for the unpretentious.",
		},
		hammer_sledge =
		{
			name = "Sludgebammer",
			desc = "Bash up a {name.rot} real hard-like.",
		},
		hammer_treemon_forest =
		{
			name = "The Tenderizer",
			desc = "Kills with severe tenderness.",
		},
		--Added this (below) bc I couldn't find an existing string for Thatcher Swamp Hammer. Remove if necessary! - chloe
		hammer_thatcher_swamp =
		{
			name = "The Bam Bamboozler",
			desc = "It eats away at your enemy's self-esteem.",
		},
		hammer_yammo =
		{
			name = "The Smashing Pumpkin",
			desc = "Crushes your enemies into a million rotten pieces.",--Winning feels so gourd.
		},
		hammer_megatreemon =
		{
			name = "The Ocular Gavel",
			desc = "Kill with one eye open.",
		},
		hammer_owlitzer_forest =
		{
			name = "Grove Bammer",
			desc = "Exudes the putrid stench of success.",
		},
		hammer_gourdo =
		{
			name = "Bare Knuckle Bammer",
			desc = "Fists so furious, they oughta be illegal.",
		},
		hammer_groak = --groak tentacle and eye-v vine
		{
			name = "Wetwhacker",
			desc = "Well that's gonna leave a mark.",
		},
		hammer_floracrane =
		{
			name = "The Grand Finale",
			desc = "Ushers your foes straight into their final act.",
		},
		hammer_bandicoot =
		{
			name = "Troublemaker",
			desc = "It's time to crack some skulls.",
		},
		polearm_treemon_forest =
		{
			name = "Long Arm of the Claw",--long-range weapon
			desc = "For the Hunter who'd only touch a {name.rot} with a ten-foot pole.",
		},
		polearm_yammo =
		{
			name = "{name.rot} Kebabber",--The Pumpkin Carver. Thresh, slash. Gourge Gouger. Hurtler. Body Drop.
			desc = "Serving up a skewer-ful of raw justice.",--Poke a pumpkin, gouge a gourd.
		},
		polearm_megatreemon =
		{
			name = "The All-Seeing Fork",
			desc = "It sees you when you're bleeding, it knows when you've been staked.",
		},
		--Owlitzer polearm not in EA. Added for future.
		--polearm_owlitzer_forest =
		--{
		--	name = "The Hurticane",
		--	desc = "The time is ow.",
		--},
		polearm_gourdo =
		{
			name = "Pike of Peril",
			desc = "Packs a multi-perforating punch that leaves foes ragged.",
		},
		polearm_bandi_swamp =
		{
			name = "Barbed Pike",
			desc = "For when you don't wanna run 'em <i>clean</i> through.",
		},
		polearm_groak =
		{
			name = "Hork Fork",
			desc = "It's a tough one to swallow.",
		},
		polearm_floracrane =
		{
			name = "Sharpoon",
			desc = "Your technique is devastatingly en pointe, my dear.",
		},
		polearm_bandicoot =
		{
			name = "Cutting Remark",
			desc = "A well-timed barb in passing can cut a foe to the quick.",
		},
		polearm_basic =
		{
			name = "Rusty Skewer",
			desc = "A dull blade is sometimes more dangerous than a sharp one.",
		},
		cleaver_basic = --not used
		{
			name = "Extra Dull Cleaver",
			desc = "Chop yourself a nice slice of {name.rot}.",
		},
		cannon_basic =
		{
			name = "Splintered {name.weapon_cannon}",
			desc = "When this {name.weapon_cannon} fires in the forest, it definitely makes a sound.",
		},
		cannon_yammo =
		{
			name = "Doomino Cannon",
			desc = "Get yer {name_multiple.rot} in a row.",
		},
		cannon_owlitzer_forest =
		{
			name = "The Keening",
			desc = "A shot carried by the righteous tempest flies true.",
		},
		cannon_gourdo =
		{
			name = "The Beefstick",
			desc = "Time to meat your maker.",
		},
		cannon_groak =
		{
			name = "The Bog Blaster",
			desc = "Your enemies are gonna <i>croak</i>.",
		},
		cannon_thatcher_swamp =
		{
			-- Has the "cluster bomb" power
			name = "Hail of Gory",
			desc = "Be grateful you're not the one cleaning up this mess.",
		},
		cannon_floracrane =
		{
			name = "Beakon of Hurt",
			desc = "Elicits the dulcet tones of your enemy's shrieks.",
		},
		cannon_bandicoot =
		{
			name = "Loose {name.weapon_cannon}",
			desc = "Let chaos reign.",
		},
		cannon_megatreemon =
		{
			name = "One Big Mother",
			desc = "Walk softly and carry a boomstick.",
		},
		shotput_basic =
		{
			name = "Old Leather {name.weapon_shotput}",
			desc = "Someone definitely spat on this.",
		},
		shotput_treemon_forest =
		{
			name = "The Doodlebug Special",
			desc = "Flies through the air with the greatest of ease.",
		},
		shotput_yammo =
		{
			name = "The Hurler",--Zesty {name.weapon_shotput}
			desc = "Things are about to get ugly.",--Beat your enemies to a pulp.
		},
		shotput_owlitzer_forest = -- zucco and windmon, it looks like?
		{
			name = "Ballmerang",
			desc = "It always comes back for more.",
		},
		shotput_groak = -- zucco and windmon, it looks like?
		{
			name = "Splatshot",
			desc = "As deadly as it is hideously sticky.",
		},
		shotput_gourdo =
		{
			name = "Basherball",
			desc = "Playtime is over.",
		},
		shotput_bandi_swamp =
		{
			name = "Boomball",--explodes on contact
			desc = "More aerodynamic than a boombox.",
		},
		shotput_floracrane =
		{
			name = "Belle of the Ball",
			desc = "It's got destructive main character energy.",
		},
		shotput_megatreemon =
		{
			name = "Mother Treek's Conker",
			desc = "Ah, that old chestnut.",
		},

		shotput_bandicoot =
		{
			name = "Juggler's Charade",
			desc = "How long can you keep the ruse afloat?",
		},

		weaponprototype =
		{
			name = "Weapon Prototype",
			desc = "Hi Mike! Have a great day!",
		},
	},
	BODY = {

		--[[BEAUTIFUL WRITER FRIENDS LOOK HERE:

		Here's a list of armour/clothing-related words, feel free to grab from it or use them as a jumping off point :)
		It's okay to mix modern and medieval terms in our game.

		*Note* Our gear doesn't actually have armour values (they just bequeath stat boosts and effects when equipped),
		so whether an armour piece is considered heavy/medium/light is just based off appearance and how you want to 
		flavour it
		-Kris

		HEAVY
			--Armour 			--Plate
			--Mail				--Chainmail/Scalemail
			--Breastplate 		--Chestplate
			--Bone 				--Pauldrons
			--Regalia			--Hauberk (shirt of mail)
		MEDIUM
			--Vest 				--Tunic
			--Leathers 			--Jacket
			--Coat 				--Cuirass
			--Corselet 			--Duster
			--Hide 				--Skins
			--Trenchcoat 		--Overalls/Coveralls
			--Cladding 			--Epaulets
			--Brigandine (sleeveless, riveted, can be cloth or leather and lined with steel plates)
			--Flak Jacket (sleeveless, more modern body armour. Military but not bulletproof)
			--Buff Coat (longsleeve leather coat worn by cavalry)
			--Gambeson (quilted, padded jacket, longsleeve)
			--Doublet (longsleeve, medieval, can be quite fancy)
		LIGHT
			--Robe 				--Tabard
			--Wrap 				--Linens
			--Dress 			--Sweater
			--Longcoat 			--Cover
			--Drape 			--Frock
			--Bodice 			--Corset
			--Blazer 			--Cape/Capelet
			--Surcoat (cloth worn by a knight, usually has an insignia)
		MISC
			--Outfit			--Adornment
			--Garb 				--Gear
			--Uniform 			--Garments
			--Clothes 			--Raiment
			--Suit 				--Vestiary
			--Apparel 			--Finery
			--Costume			--Bustier
		]]

		--basic
		basic = {
			name = "Basic Tunic",
			desc = "Better than running around in the buck."
		},

		--bosses
		bandicoot = {
			name = "{name.bandicoot}'s Biting Cuirass",
			desc = "A comfortable yet stylish tunic. Tends to shed."
		},
		bonejaw = {
			name = "{name.bonejaw} Breastplate",
			desc = "A breastplate of scale and bone does well to intimidate."
		},
		megatreemon = {
			name = "{name.megatreemon}'s Sylvan Weave",
			desc = "A piece to wear with pride.",
		},
		owlitzer =
		{
			name = "{name.owlitzer}'s Plumed Doublet",
			desc = "Become a bird of prey.",
		},
		thatcher = {
			name = "{name.thatcher}'s Super Brigandine",
			desc = "A lightweight thorax of armour."
		},

		--minibosses
		gourdo = {
			name = "{name.gourdo} Vest",
			desc = "Athletic gear for the team player.",
		},
		yammo = {
			name = "{name.yammo} Singlet",
			desc = "A gourd-geous piece of attire.",
		},
		floracrane = {
			name = "{name.floracrane} Raiments",
			desc = "In fighting and in dancing, one benefits from a full range of motion.",
		},
		seeker = {
			name = "{name.seeker} Coat",
			desc = "",
		},
		groak = {
			name = "{name.groak} Body Casing",
			desc = "Harder to slip on than a pair of wet jeans.",
		},

		--regular
		rotwood = {
			name = "{name.rotwood} Breastplate",
			desc = "If you can get over the splinters, it's a very effective breastplate."
		},
		blarmadillo = {
			name = "{name.blarmadillo} Chestplate",
			desc = "Properly protects from punches, but pretty prone to pilling."
		},
		cabbageroll = {
			name = "{name.cabbageroll} Longcoat",
			desc = "Just don't touch your eyes after buttoning it up."
		},
		zucco = {
			name = "{name.zucco} Singlet",
			desc = "Sometimes you need to get into a pickle to get out of one.",
		},
		battoad = {
			name = "{name.battoad} Surcoat",
			desc = "Ready for {name.battoad}tle!",
		},
		mothball = {
			name = "{name.mothball} Fur Coat",
			desc = "It's nearly impossible to be in a bad mood while wearing one of these.",
		},
		bulbug = {
			name = "{name.bulbug} Exoskeleton",
			desc = "Two skeletons are better than one.",
		},
		treemon =
		{
			name = "{name.treemon} Trunk",
			desc = "All bark, and some bite.",
		},
		windmon =
		{
			name = "{name.windmon} Breastplate",
			desc = "For a suit of armour, it's surprisingly breezy.",
		},
		gnarlic =
		{
			name = "{name.gnarlic} Chest Wrap",
			desc = "A pungent garment that eliminates the need for personal deodorant.",
		},
		eyev =
		{
			name = "{name.eyev} Wrap",
			desc = "Just because you're fighting {name_multiple.rot} doesn't mean you can't look cute.",
		},
		swarmy =
		{
			name = "{name.swarmy} Top Glaze",
			desc = "Looks like it's painted on. Because it is.",
		},
		slowpoke =
		{
			name = "{name.slowpoke} Armour",
			desc = "Someone's gotta keep an eye on you.",
		},
		woworm =
		{
			name = "{name.woworm} Hauberk",
			desc = "Harness the protective qualities of {name.woworm} shells.",
		},
	},
	HEAD = {
		--[[
		BEAUTIFUL WRITER FRIENDS LOOK HERE:
			Here's a list of headgear words, feel free to grab from it or use them as a jumping off point :)
			It's okay to mix modern and medieval terms in our game.

			*Note* Our gear doesn't actually have armour values (they just bequeath stat boosts and effects when equipped),
			so whether an armour piece is considered heavy/medium/light is just based off appearance and how you want to 
			flavour it
			-Kris

		HEAVY
			--Helm/Great Helm 			--Helmet
			--Hardhat 					--Bascinet (funny lil helmet with a beak)
			--Armet (quintessential suit of armour helmet)
			--Barbute (metal helmet with T-shaped eye/nose space)
			--Sallet (metal helmet that covers the top half of the face and the back of the neck)
			--Kettlehat (helmet that looks like a regular hat, but metal)
			--Bevor (metal piece that protects your neck, doesn't cover the face on its own but can be paired with helmets)
		MEDIUM
			--Coif (mail) 			--Cap/Skullcap
			--Hood 					--Visor
			--Toque					--Headdress (keep cultural sensitivity in mind with this one :) )
			--Pith Helmet (safari hat)
		LIGHT
			--Cowl 					--Bonnet
			--Veil 					--Shroud
			--Beret 				--Tricorne
		DECORATIVE
			--Crown 				--Diadem
			--Tiara 				--Circlet
			--Mask 					--Hatpin
			--Coronet 				--Garland
			--Clip/Barrette			--Ribbon/Bow
		MISC
			--Headgear 				--Hat
			--Headpiece				--Headwrap
		]]

		--basic
		basic = {
			name = "Basic Headband",
			desc = "Keep the sweat from your eyes while bashing {name_multiple.rot}.",
		},

		--bosses
		bandicoot = {
			name = "{name.bandicoot}'s Toothed Armet",
			desc = "This helmet once housed many devious thoughts. Now, it houses yours.",
		},
		bonejaw = {
			name = "{name.bonejaw} Head Cage",
			desc = "Intimidating and protective. Good qualities in a helm.",
		},
		megatreemon = {
			name = "{name.megatreemon}'s Avid Circlet",
			desc = "Only for those who have tread within the forest's inner circle.",
		},
		thatcher = {
			name = "{name.thatcher}'s Vigilant Visor",
			desc = "Why so bug-eyed?",
		},
		owlitzer =
		{
			name = "The Cowlitzer",
			desc = "The only cowl made from an owl.",
		},

		--minibosses
		floracrane = {
			name = "{name.floracrane} Garland",
			desc = "Combat is an elegant dance.",
		},
		gourdo = {
			name = "{name.gourdo}'s Noggin-Padder",
			desc = "Proper padding to guard your gourd.",
		},
		yammo = {
			name = "{name.yammo}'s Noggin-Padder",
			desc = "Orange you glad you didn't crack your melon?",
		},
		seeker = {
			name = "{name.seeker} Helm",
			desc = "",
		},
		groak = {
			name = "{name.groak}'s Best",
			desc = "What makes you pretty on the inside also makes you pretty on the outside.",
		},

		--regular enemies
		rotwood = {
			name = "{name.rotwood} Helm",
			desc = "Takes a solid knock on wood.",
		},
		blarmadillo = {
			name = "{name.blarmadillo} Kettlehat",
			desc = "It's a dome for the dome.",
		},
		cabbageroll = {
			name = "{name.cabbageroll} Buddy",
			desc = "Never fight alone again.",
		},
		zucco = {
			name = "{name.zucco}'s Noggin-Padder",
			desc = "A full helmet might've been too cucumbersome.",
		},
		battoad = {
			name = "{name.battoad} Wings",
			desc = "Rain terror from the skies.",
		},
		mothball = {
			name = "{name.mothball} Ushanka",
			desc = "So comfortingly floofy, you can't help but feel a bit friendlier wearing it.",
		},
		bulbug = {
			name = "{name.bulbug} Eyes",
			desc = "See your enemies from a {name.bulbug}'s perspective.",
		},
		treemon =
		{
			name = "Treeara",
			desc = "Pretty in {name.treemon}.",
		},
		windmon =
		{
			name = "{name.windmon} Helm",
			desc = "Charge into hunts with confidence and gusto.",
		},
		gnarlic =
		{
			name = "{name.gnarlic} Head Stalk",
			desc = "Stalk your prey.",
		},
		eyev =
		{
			name = "{name.eyev} Shroud",
			desc = "Woe be upon {name_multiple.rot} who won't leaf you alone.",
		},
		swarmy =
		{
			name = "{name.swarmy} Laurels",
			desc = "Try not to rest on it.",
		},
		slowpoke =
		{
			name = "{name.slowpoke} Helmet",
			desc = "Now you, too, can be as hard-headed as the humble {name.slowpoke}.",
		},
		woworm =
		{
			name = "{name.woworm} Helmet",
			desc = "Open-faced so you don't trap the smell.",
		},
	},
	WAIST = {

		--[[BEAUTIFUL WRITER FRIENDS LOOK HERE:

		HEAVY
		-Chausses (chainmail, covers the whole leg)
		-Sabaton (foot portion of a suit of armour)
		-Faulds (the "skirt" part of a suit of armour)
		-Tonlet (metal skirt of a suit of armour, but flared slightly out)

		MEDIUM
		-Cuisses (quilted, padded armour for the thigh specifically)
		-Chaps

		LIGHT
		-Pants
		-Tights
		-Trousers
		-Skirt
		-Kilt
		-Slacks
		-Knickers (underwear)
		-Breeches
		-Shorts
		-Pantaloons
		-Loincloth
		-Sash
		-Belt
		-Petticoat (undergarment, like a skirt)
		-Culottes
		-Capris

		-Cinch
		Shoes
		-Galoshes (shoes)

		MISC
		-Greaves (leg armour, can be metal, leather or cloth)
		]]

		--basic
		basic = {
			name = "Basic Leggings",
			desc = "The sandal blisters are only <i>mildly</i> intolerable!",
		},

		--bosses
		bandicoot = {
			name = "{name.bandicoot}'s Blue Suede Boots",
			desc = "Do not step on them.",
		},
		bonejaw = {
			name = "Rigid {name.bonejaw} Jawbelt",
			desc = "",
		},
		megatreemon = {
			name = "{name.megatreemon}'s Bark-Kilt",
			desc = "Let your sovereignty take root.",
		},
		owlitzer =
		{
			name = "{name.owlitzer}'s' Shearling Britches",
			desc = "How can something so dangerous be so soft?",
		},
		thatcher = {
			name = "{name.thatcher}'s Super Elasti-Pants",
			desc = "They're not underpants! Stop calling them underpants!",
		},

		--minibosses
		gourdo = {
			name = "{name.gourdo} Elasti-Shorts",
			desc = "May you cling to life as tightly as these shorts cling to you.",
		},
		yammo = {
			name = "{name.yammo} Elasti-Shorts",
			desc = "Comfy shorts with an astonishingly wide range of movement.",
		},
		zucco = {
			name = "{name.zucco} Elasti-Shorts",
			desc = "In battle you should leave nothing up to chance, or the imagination.",
		},
		floracrane = {
			name = "{name.floracrane} Skirt",
			desc = "Twirls gracefully on the battlefield.",
		},
		seeker = {
			name = "{name.seeker} WAIST",
			desc = "",
		},
		groak = {
			name = "{name.groak} Drippings",
			desc = "Take a bath after wearing.",
		},

		--regular
		rotwood = {
			name = "{name.rotwood} Faulds",
			desc = "No, it's not mahogany.",
		},
		blarmadillo = {
			name = "{name.blarmadillo} Trunks",
			desc = "For someone who nose their way around a trap or two.",
		},
		cabbageroll = {
			name = "{name.cabbageroll} Sash",
			desc = "Don't go out on a hunt without a friend to watch your behind.",
		},
		battoad = {
			name = "{name.battoad} Legs",
			desc = "Always be ready to leap into the fray.",
		},
		mothball = {
			name = "{name.mothball} Fur Leggings",
			desc = "Double-layered for extra comfort.",
		},
		bulbug = {
			name = "{name.bulbug} Tarsi",
			desc = "Makes a scritching noise when you walk.",
		},
		treemon =
		{
			name = "{name.treemon} Fig Leaf",
			desc = "A very modest piece of armour.",
		},
		windmon =
		{
			name = "{name.windmon} Greaves",
			desc = "Perfect for weathering the elements.",
		},
		gnarlic =
		{
			name = "{name.gnarlic} Bulb Shorts",
			desc = "These shorts really grow on you.",
		},
		eyev =
		{
			name = "{name.eyev} Twine Cinch",
			desc = "Soft, flowy leaves, secured by an only <i>slightly</i> sticky pink belt.",
		},
		swarmy =
		{
			name = "{name.swarmy} Slimekilt",
			desc = "Complete with {name.swarmy} hand clasp.",
		},
		slowpoke =
		{
			name = "{name.slowpoke} Boots",
			desc = "A thick hide to cover your own.",
		},
		woworm =
		{
			name = "{name.woworm} Aketon",
			desc = "The waistband is very elastic.",
		},
	},
	POTIONS = {
		heal1 = {
			name = "Soothing Spirits",
			desc = "A sturdy bottle, able to hold a good amount of liquid.\n\nEffects trigger after drinking.",
		},

		quick_heal1 = {
			name = "Bubbling Brew",
			desc = "A collection of smaller flasks, each of them holds a perfect swallow of liquid.\n\nEffects trigger after drinking.",
		},

		duration_heal1 = {
			name = "Misting Mixture",
			desc = "The mixture seems to be endlessly misting.\n\nEffects trigger after drinking."
		},
	},

	TONICS =
	{
		yammo_rage = {
			name = "Spicy Pumpkin Seeds",
			desc = "Flavoured with pure, distilled <#RED>{name.yammo}</> rage.\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		full_shield = {
			name = "{name.bulbug} Boba",
			desc = "Daily treats are scientifically proven to fortify body and soul.\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		explotion = {
			name = "Popping Candy",
			desc = "These crushed <#RED>{name.trap_bomb_pinecone}</> bits will add some <i>oompf</> to any <#RED>{name.potion}</>.\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		zucco_dash = {
			name = "Coffee Jelly",
			desc = "Gotta go fast.\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		juggernaut = {
			name = "Juggernaut Jelly",
			desc = "It's mostly made of <#RED>{name.battoad}</> slime.\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		shrink = {
			name = "Small Beans",
			desc = "Some <#RED>Pearls</> make you larger... these <#RED>Pearls</> make you small.\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		mudslinger = {
			name = "Chocolate Foam",
			desc = "Contains your yearly recommended intake of mud.\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		projectile_repeat = {
			name = "{name.battoad} Eggs",
			desc = "They're great for spitting!\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		resolve1 = {
			name = "Tincture of Stone Resolve",
			desc = "Cannot be interrupted by hits for {duration} second(s).\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},

		freeze = {
			name = "Ice Cold Slushie",
			desc = "Make your brain freeze into everyone else's problem.\n\n<#RED>{name_multiple.tonic}</> are automatically added to your <#RED>{name.potion}</> when equipped.\n\nEffects trigger after drinking.",
		},
	},

	FOOD =
	{
		spoiled_food = {
			name = "Spoiled Food",
			desc = "Are you sure you wanna eat that?\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		stuffed_blarma = {
			name = "Stuffed {name.blarmadillo}",
			desc = "Soon you will be, too.\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		spiced_gourd = {
			name = "Spiced Gourd",
			desc = "It tastes kind of how autumn leaves smell.\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		salad = {
			name = "Leaf Salad",
			desc = "Supposedly \"healthy\".\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		roast_tail = {
			name = "Roast Tail",
			desc = "Tastes hearty, but leaves one feeling fit and spry.\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		noodle_legs = {
			name = "Noodle Legs",
			desc = "Wriggles all the way down!\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		meatwich = {
			name = "Meatwich",
			desc = "Take some meat. Put it between some other meat.\nEnjoy.\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		haggis = {
			name = "Haggis",
			desc = "Looks offal, tastes great.\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		gourd_stew = {
			name = "Gourd Stew",
			desc = "You can even eat the bowl!\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		cased_sausage = {
			name = "Cased Sausage",
			desc = "Pack yourself a snack for the road, just in case.\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		dimsum = {
			name = "Dim Sum",
			desc = "You know you want sum.\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},

		cabbage_wrap = {
			name = "Cabbage Wrap",
			desc = "Some <#RED>{name_multiple.cabbageroll}</> were harmed in the making of this snack.\n\n<#RED>Lunch Boxes</> are automatically eaten at the start of a run.\n\n<#RED>Buffs</> remain active for the run's duration.",
		},
	},

	KEY_ITEMS = {
		recipe_generic =
		{
			name = "%s Recipe: %s",
			desc = "Unlocks the recipe for [%s]."
		},
		basic =
		{
			name = "Basic Armour Recipe Book",
			desc = "Barely worth the paper it's printed on."
		},


		bandicoot =
		{
			name = "{name.bandicoot} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.bandicoot}</> bits."
		},
		bonejaw =
		{
			name = "{name.bonejaw} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.bonejaw}</> bits."
		},
		rotwood =
		{
			name = "{name.rotwood} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.rotwood}</> bits."
		},
		thatcher =
		{
			name = "{name.thatcher} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.thatcher}</> bits."
		},
		blarmadillo =
		{
			name = "{name.blarmadillo} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.blarmadillo}</> bits."
		},
		cabbageroll =
		{
			name = "{name.cabbageroll} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.cabbageroll}</> bits."
		},
		yammo =
		{
			name = "{name.yammo} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.yammo}</> bits."
		},
		megatreemon =
		{
			name = "{name.megatreemon} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.megatreemon}</> bits."
		},
		zucco =
		{
			name = "{name.zucco} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.zucco}</> bits."
		},
		gourdo =
		{
			name = "{name.gourdo} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.gourdo}</> bits."
		},
		battoad =
		{
			name = "{name.battoad} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.battoad}</> bits."
		},
		floracrane =
		{
			name = "{name.floracrane} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.floracrane}</> bits."
		},
		mothball =
		{
			name = "{name.mothball} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.mothball}</> bits."
		},
		seeker =
		{
			name = "{name.seeker} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.seeker}</> bits."
		},
		groak =
		{
			name = "{name.groak} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.groak}</> bits."
		},
		bulbug =
		{
			name = "{name.bulbug} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.bulbug}</> bits."
		},
		slowpoke =
		{
			name = "{name.slowpoke} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.slowpoke}</> bits."
		},
		owlitzer =
		{
			name = "{name.owlitzer} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.owlitzer}</> bits."
		},
		treemon =
		{
			name = "{name.treemon} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.treemon}</> bits."
		},
		-- windmon =
		-- {
		-- 	name = "{name.windmon} Armour Recipe Book",
		-- 	desc = "Teaches a crafter how to make armour from <#RED>{name.windmon}</> bits."
		-- },
		eyev =
		{
			name = "{name.eyev} Armour Recipe Book",
			desc = "Teaches a crafter how to make armour from <#RED>{name.eyev}</> bits."
		},
	},

	KONJUR = {
		name = "{name.konjur}",
		desc = "The enigmatic and magical substance that seems to fuel all of the Rotwood's misgivings.",
	},

	--When writing material names/descriptions, try to always include the name of the monster it drops from in the item title (if any) and include what area the monster is found in in the description (if any)
	MATERIALS = {
		TAKE_SOUL_BUTTON = "<p bind='Controls.Digital.ACTION' color=0> Take",
		TAKE_SOUL_BUTTON_NAME = "<p bind='Controls.Digital.ACTION' color=0> Take {name}",
		konjur =
		{
			name = "{name.konjur}",
			desc = "Raw {name.konjur}",
		},

		glitz =
		{
			name = "Glitz",
			desc = "Small fragments of sparkly volcanic ash.\n\nUsed to craft <#BLUE>{name_multiple.cosmetic}</>.",
		},

		konjur_soul_lesser =
		{
			name = "{name.konjur_soul_lesser}",
			desc = "A hunk of pure, solidified <#KONJUR>{name.i_konjur}</>.\n\nFound in: <#RED>Special Rooms</>",
			name_multiple_fmt = "{name_multiple.konjur_soul_lesser} ({count})",
		},

		konjur_soul_greater =
		{
			name = "{name.konjur_soul_greater}",  
			desc = "Heavily condensed, solid <#KONJUR>{name.i_konjur}</>.\n\nIt was harvested from an especially fearsome <#RED>{name.rot}</>.\n\nFound in: <#RED>{name.rot_miniboss} Rooms</>",
			name_multiple_fmt = "{name_multiple.konjur_soul_greater} ({count})",
		},

		konjur_heart =
		{
			name = "{name.konjur_heart}", 
			desc = "Magnificently powerful, solid <#KONJUR>{name.i_konjur}</>, recovered from a <#RED>{name.rot_boss}</>.\n\nIt is prized by the {name_multiple.foxtails}.\n\nFound in: <#RED>{name.rot_boss} Rooms</>",
			name_multiple_fmt = "{name_multiple.konjur_heart} ({count})",
		},

		-- Writer!
		konjur_heart_megatreemon =
		{
			name = "{name.megatreemon} {name.konjur_heart}", 
			desc = "Magnificently powerful, solid <#KONJUR>{name.i_konjur}</>, recovered from a <#RED>{name.megatreemon}</>.\n\nIt is prized by the {name_multiple.foxtails}.",
			name_multiple_fmt = "{name.megatreemon} {name_multiple.konjur_heart} ({count})",
		},

		-- Writer!
		konjur_heart_owlitzer =
		{
			name = "{name.owlitzer} {name.konjur_heart}", 
			desc = "Magnificently powerful, solid <#KONJUR>{name.i_konjur}</>, recovered from a <#RED>{name.owlitzer}</>.\n\nIt is prized by the {name_multiple.foxtails}.",
			name_multiple_fmt = "{name.owlitzer} {name_multiple.konjur_heart} ({count})",
		},

		-- Writer!
		konjur_heart_bandicoot =
		{
			name = "{name.bandicoot} {name.konjur_heart}", 
			desc = "Magnificently powerful, solid <#KONJUR>{name.i_konjur}</>, recovered from a <#RED>{name.bandicoot}</>.\n\nIt is prized by the {name_multiple.foxtails}.",
			name_multiple_fmt = "{name.bandicoot} {name_multiple.konjur_heart} ({count})",
		},

		-- Writer!
		konjur_heart_thatcher =
		{
			name = "{name.thatcher} {name.konjur_heart}", 
			desc = "Magnificently powerful, solid <#KONJUR>{name.i_konjur}</>, recovered from a <#RED>{name.thatcher}</>.\n\nIt is prized by the {name_multiple.foxtails}.",
			name_multiple_fmt = "{name.thatcher} {name_multiple.konjur_heart} ({count})",
		},

		ingot_treemon_forest =
		{
			name = "Arbour Fortifying Ingot",
			desc = "",
			name_multiple_fmt = "Arbour Fortifying Ingot ({count})",
		},

		ingot_owlitzer_forest =
		{
			name = "Dusk Fortifying Ingot",
			desc = "",
			name_multiple_fmt = "Dusk Fortifying Ingot ({count})",
		},

		ingot_bandi_swamp =
		{
			name = "Clever Fortifying Ingot",
			desc = "",
			name_multiple_fmt = "Clever Fortifying Ingot ({count})",
		},

		ingot_thatcher_swamp =
		{
			name = "Insect Fortifying Ingot",
			desc = "",
			name_multiple_fmt = "Insect Fortifying Ingot ({count})",
		},

		rotwood_bark =
		{
			name = "{name.rotwood} Bark",
			desc = "Its bite is admittedly much worse.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		rotwood_twig =
		{
			name = "{name.rotwood} Twig",
			desc = "A gnarled, knot-pocked twig.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		rotwood_root =
		{
			name = "{name.rotwood} Root",
			desc = "A section from the subterranean labyrinth of roots from a <#RED>{name.rotwood}</>.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		rotwood_face =
		{
			name = "{name.rotwood} Grimace",
			desc = "Wood in the gnarly features of a <#RED>{name.rotwood}'s</> face.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		thatcher_antennae =
		{
			name = "{name.thatcher} Feeler",
			desc = "Wiry and durable antennae.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},

		thatcher_fur =
		{
			name = "{name.thatcher} Down",
			desc = "Makes for decent stuffing.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},

		thatcher_limb =
		{
			name = "{name.thatcher} Tarsus",
			desc = "A long limb belonging to a <#RED>{name.thatcher}</>.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},

		thatcher_wing =
		{
			name = "{name.thatcher} Wing",
			desc = "A transparent wing of a <#RED>{name.thatcher}</>.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},

		thatcher_shell =
		{
			name = "{name.thatcher} Husk",
			desc = "A solid shell.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},

		thatcher_skull =
		{
			name = "{name.thatcher} Skull",
			desc = "A skull that resembling a <#RED>{name.thatcher}</> when it was alive.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},

		bonejaw_claw =
		{
			name = "{name.bonejaw} Claw",
			desc = "A sharp claw. The worst kind\n\nFound in: <#RED></>",
		},

		bonejaw_hide =
		{
			name = "{name.bonejaw} Rind",
			desc = "A coriaceous yet mealy hide.\n\nFound in: <#RED></>",
		},

		bonejaw_skull =
		{
			name = "{name.bonejaw} Skull",
			desc = "A skull of an <#RED>{name.bonejaw}</>. A good chunk exposed when breathing\n\nFound in: <#RED></>",
		},

		bonejaw_spike =
		{
			name = "{name.bonejaw} Tusk",
			desc = "One of many spikes from an <#RED>{name.bonejaw}</>.\n\nFound in: <#RED></>",
		},

		bonejaw_tail =
		{
			name = "{name.bonejaw} Tail",
			desc = "An <#RED>{name.bonejaw}'s</> serpentine tail.\n\nFound in: <#RED></>",
		},

		bonejaw_tooth =
		{
			name = "{name.bonejaw} Fang",
			desc = "A well-kept, well pointed tooth.\n\nFound in: <#RED></>",
		},

		bandicoot_tail =
		{
			name = "{name.bandicoot} Tail",
			desc = "Rarely wags.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		--[[
		bandicoot_hide =
		{
			name = "{name.bandicoot} Hide",
			desc = "Good at keeping in heat.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		bandicoot_skull =
		{
			name = "{name.bandicoot} Skull",
			desc = "A {name.bandicoot}'s former skull post removal.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		bandicoot_wing =
		{
			name = "{name.bandicoot} Wings",
			desc = "Leathery wings with incredible tensile strength.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		bandicoot_hand =
		{
			name = "{name.bandicoot} Hand",
			desc = "Once-nimble fingers taken from an <#RED>{name.bandicoot}</>.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		arak_eye =
		{
			name = "{name.arak} Eye",
			desc = "A big eye with an intense gaze.\n\nFound in: <#RED></>",
		},

		arak_leg =
		{
			name = "{name.arak} Leg",
			desc = "A hairy leg.\n\nFound in: <#RED></>",
		},

		arak_shell =
		{
			name = "{name.arak} Shell",
			desc = "A silky shell.\n\nFound in: <#RED></>",
		},

		arak_skull =
		{
			name = "{name.arak} Skull",
			desc = "Even for a skull, it's a fright.\n\nFound in: <#RED></>",
		},

		arak_web =
		{
			name = "{name.arak} Web",
			desc = "Silky and tensile.\n\nFound in: <#RED></>",
		},

		owlitzer_fur =
		{
			name = "{name.owlitzer} Down",
			desc = "Fluffy feather down, harvested from an <#RED>{name.owlitzer}</>.\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},

		owlitzer_claw =
		{
			name = "{name.owlitzer} Claw",
			desc = "The razor sharp claws of an <#RED>{name.owlitzer}</>.\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},

		owlitzer_pelt =
		{
			name = "{name.owlitzer} Pelt",
			desc = "Majestic and beautiful. It's almost a shame the creature was felled.\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},

		--[[
		owlitzer_feather =
		{
			name = "{name.owlitzer} Feather",
			desc = "Inlficts a mean tickle.\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},

		owlitzer_fur =
		{
			name = "{name.owlitzer} Fur",
			desc = "Warm, fuzzy fur... and feathers\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},

		owlitzer_foot =
		{
			name = "{name.owlitzer} Foot",
			desc = "A lucky foot?\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},

		owlitzer_skull =
		{
			name = "{name.owlitzer} Skull",
			desc = "A skull with big eye sockets.\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},
		]]
		--[[
		flower_bush =
		{
			name = "Bush Flower",
			desc = "Suits a garden well.",
		},

		flower_violet =
		{
			name = "Violet",
			desc = "Plant it in your garden.",
		},
		]]

		------------- GLOBAL DROPS not in game
		--[[
		generic_bone =
		{
			name = "Rot Bone",
			desc = "The skeleton bits of a Rot.",
		},
		generic_meat =
		{
			name = "Rot Meat",
			desc = "A prime cut of Rot meat.",
		},
		generic_hide =
		{
			name = "Rot Hide",
			desc = "A section of hide from a Rot.",
		},
		generic_leaf =
		{
			name = "Leaf",
			desc = "It's a leaf. Wonder where it came from?",
		},
		]]

		------------- STARTING FOREST DROPS not in game 
		--[[
		forest_fern =
		{
			name = "Hollow Root Fern",
			desc = "Only found in Hollow Root Forest",
		},
		forest_sap =
		{
			name = "Hollow Root Sap",
			desc = "Only found in Hollow Root Forest",
		},
		forest_twigs =
		{
			name = "Hollow Root Twigs",
			desc = "Only found in Hollow Root Forest",
		},
		forest_seed =
		{
			name = "Hollow Root Seeds",
			desc = "Only found in Hollow Root Forest",
		},
		]]

		------ STARTING FOREST CREATURE DROPS
		--[[
		cabbageroll_leg =
		{
			name = "{name.cabbageroll} Stalk",
			desc = "Wee legs let them twits crawl about\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		]]
		cabbageroll_skin =
		{
			name = "{name.cabbageroll} Skin",
			desc = "<#RED>{name_multiple.cabbageroll}</> have <i>layers</i>.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		cabbageroll_baby =
		{
			name = "{name.cabbageroll_elite} Bulb",
			desc = "The larval form of a <#RED>{name.cabbageroll_elite}</>. It may look cute, but don't be fooled.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		blarmadillo_hide =
		{
			name = "{name.blarmadillo} Hide",
			desc = "A section of rough, thick skin. The last owner should've moisturized.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		blarmadillo_trunk =
		{
			name = "{name.blarmadillo_elite} Trunk",
			desc = "The elongated snoot of a felled <#RED>{name.blarmadillo_elite}</>. It squishes in a displeasing manner.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		--[[blarmadillo_scale =
		{
			name = "{name.blarmadillo} Slate",
			desc = "A callus scale\n\nFound in: <#RED>{name.treemon_forest}</>",
		},]]

		treemon_arm =
		{
			name = "{name.treemon} Branch",
			desc = "A twisted branch, sawn off a felled <#RED>{name.treemon}</>.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		treemon_cone =
		{
			name = "{name.treemon_elite} Cone",
			desc = "It's basically a baby <#RED>{name.treemon_elite}</>.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		--[[
		treemon_stick =
		{
			name = "{name.treemon} Stick",
			desc = "Found in: <#RED>{name.treemon_forest}</>",
		},
		]]

		megatreemon_bark =
		{
			name = "{name.megatreemon} Bark",
			desc = "Found in: <#RED>{name.treemon_forest}</>",
		},
		megatreemon_hand =
		{
			name = "{name.megatreemon} Claw",
			desc = "There's just no reason for trees to have thumbs.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		megatreemon_cone =
		{
			name = "{name.megatreemon} Paincone",
			desc = "The volatile seed of a nasty <#RED>{name.megatreemon}</>.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		--[[
		megatreemon_wood =
		{
			name = "{name.megatreemon} Wood",
			desc = "Found in: <#RED>{name.treemon_forest}</>",
		},
		]]

		--[[
		yammo_tail =
		{
			name = "{name.yammo} Tail",
			desc = "Pockmarked and vegetated\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		]]
		yammo_skin =
		{
			name = "{name.yammo} Dermis",
			desc = "It smells faintly citrusy.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		yammo_stem =
		{
			name = "{name.yammo_elite} Stem",
			desc = "A rough, fibrous stem that once served as a <#RED>{name.yammo_elite}'s</> horn.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		zucco_claw =
		{
			name = "{name.zucco_elite} Claw",
			desc = "They're a lot safer now they're not attached to a <#RED>{name.zucco_elite}</>.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		zucco_skin =
		{
			name = "{name.zucco} Skin",
			desc = "It looks like it'd be crunchy and refreshing if you bit into it.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		--[[
		zucco_stem =
		{
			name = "{name.zucco} Stem",
			desc = "Found in: <#RED>{name.treemon_forest}</>",
		},
		]]
		--[[
		gourdo_finger =
		{
			name = '{name.gourdo} Finger',
			desc = "Found in: <#RED>{name.treemon_forest}</>",
		},
		]]
		gourdo_hat =
		{
			name = '{name.gourdo} Hat',
			desc = "A leafy stem, carved off the top of a <#RED>{name.gourdo}</>.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		gourdo_skin =
		{
			name = '{name.gourdo_elite} Skin',
			desc = "Dark red rind from a <#RED>{name.gourdo_elite}'s</> behind.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		beets_body =
		{
			name = "{name.beets} Body",
			desc = "Whoops, I guess someone dropped the <#RED>{name.beets}</>.\n\nFound in: <#RED>{name.treemon_forest}</>",
		},
		beets_leaf =
		{
			name = "{name.beets_elite} Leaf",
			desc = "How can the top of a <#RED>{name.beets_elite}</> be so soft, yet hurt so bad?\n\nFound in: <#RED>{name.treemon_forest}</>",
		},

		gnarlic_cloves =
		{
			name = "{name.gnarlic} Cloves",
			desc = "They emanate a pungent stench.\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},
		gnarlic_sprouts =
		{
			name = "{name.gnarlic_elite} Sprouts",
			desc = "A grassy tuft. It was taken from atop the head of a <#RED>{name.gnarlic_elite}</>.\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},
		windmon_trunk =
		{
			name = "{name.windmon} Trunk",
			desc = "A sturdy piece of wood, harvested from the center of a <#RED>{name.windmon}</>\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},
		windmon_horn =
		{
			name = "{name.windmon_elite} Horn",
			desc = "Leaves and branches pulled from a <#RED>{name.windmon}'s</> canopy.\n\nFound in: <#RED>{name.owlitzer_forest}</>",
		},

		------------- SWAMP BIOME DROPS
		--[[ --not in game
		swamp_slime =
		{
			name = "Kanft Slime",
			desc = "Only found in Kanft Swamp.",
		},
		swamp_moss =
		{
			name = "Kanft Moss",
			desc = "Only found in Kanft Swamp.",
		},
		swamp_spore =
		{
			name = "Kanft Spore",
			desc = "Only found in Kanft Swamp.",
		},
		swamp_vines =
		{
			name = "Kanft Vines",
			desc = "Only found in Kanft Swamp.",
		},
		]]

		------ SWAMP CREATURE DROPS

		battoad_wing =
		{
			name = '{name.battoad} Wing',
			desc = "A stretchy wing with an only mildly offputting odour.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		battoad_leg =
		{
			name = '{name.battoad_elite} Leg',
			desc = "A generous hock of <#RED>{name.battoad}</> meat.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		--[[
		battoad_scale =
		{
			name = '{name.battoad} Scale',
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},

		battoad_tongue =
		{
			name = '{name.battoad} Tongue',
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		battoad_eyeball =
		{
			name = '{name.battoad} Eyeball',
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		mothball_fluff =
		{
			name = "{name.mothball} Fluff",
			desc = "Cloud-soft down, harvested from a <#RED>{name.mothball}</>.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		mothball_teen_ear =
		{
			name = "{name.mothball_elite} Ears",
			desc = "They tickle.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		--[[
		mothball_eyeballs =
		{
			name = "{name.mothball} Eyeballs",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},

		mothball_teen_claw =
		{
			name = "{name.mothball} Claw",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		mothball_teen_tail =
		{
			name = "{name.mothball} Tail",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		eyev_vine =
		{
			name = "{name.eyev} Vine",
			desc = "A rubbery vine, shorn from an <#RED>{name.eyev}</>.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		eyev_eyelashes =
		{
			name = "{name.eyev_elite} Eyelashes",
			desc = "Frozen forever in a sultry stare.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		--[[
		eyev_eyeball =
		{
			name = "{name.eyev} Eyeball",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		seeker_wood_stick =
		{
			name = "{name.seeker} Wood Stick",
			desc = "What's the point of a nature walk if you don't come back with a good stick?\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		seeker_wood_plank =
		{
			name = "{name.seeker} Wood Plank",
			desc = "Sturdy bark pulled from a felled <#RED>{name.seeker}</>.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},
		seeker_leaf =
		{
			name = "{name.seeker} Leaf",
			desc = "Crunchy leaves taken from a felled <#RED>{name.seeker}</>.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},
		seeker_beard =
		{
			name = "{name.seeker_elite} Beard",
			desc = "It feels scratchy and full of wisdom.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},
		seeker_boquet =
		{
			name = "{name.seeker} Bouquet",
			desc = "A <#RED>{name.seeker}</> by any other name would smell like feet.\n\nFound in: <#RED>{name.thatcher_swamp}</>",
		},

		floracrane_feather =
		{
			name = "{name.floracrane} Down",
			desc = "Soft, elegant feathers harvested from a <#RED>{name.floracrane}</>.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		floracrane_beak =
		{
			name = "{name.floracrane_elite} Beak",
			desc = "Are <#RED>{name_multiple.floracrane_elite}</> shy? They're all tongue-tied.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		--[[
		floracrane_tail =
		{
			name = "{name.floracrane} Plume",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		floracrane_leg =
		{
			name = "{name.floracrane} Drumstick",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		floracrane_neck =
		{
			name = "{name.floracrane} Vines",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		floracrane_feet =
		{
			name = "{name.floracrane} Foot",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		mossquito_cap =
		{
			name = "{name.mossquito} Cap",
			desc = "The <#RED>{name.mossquito}</> fashion world is abuzz over this hat style.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		mossquito_tooth =
		{
			name = "{name.mossquito_elite} Tooth",
			desc = "No wonder their bites hurt so much.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		--[[
		mossquito_nose =
		{
			name = "{name.mossquito} Nose",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		slowpoke_eye =
		{
			name = "{name.slowpoke_elite} Eye",
			desc = "A piercing eye, harvested from a <#RED>{name.slowpoke_elite}</>.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		slowpoke_tail =
		{
			name = "{name.slowpoke} Tail",
			desc = "A pleasingly plump tail.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		--[[
		slowpoke_jaw =
		{
			name = "{name.slowpoke} Jaw",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		bulbug_jaw =
		{
			name = "{name.bulbug} Pincers",
			desc = "Huge insect jaws with impressive piercing power.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		bulbug_bulb =
		{
			name = "{name.bulbug_elite} Bulb",
			desc = "A classic <#RED>{name.bulbug_elite}</> bulb. The air around it feels fuzzy with energy.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		--[[
		bulbug_claw =
		{
			name = "{name.bulbug} Claw",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		groak_tentacle =
		{
			name = "{name.groak} Tentacle",
			desc = "A <#RED>{name.groak}'s</> squishy mustache.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		groak_elite =
		{
			name = "{name.groak_elite} Wigglers",
			desc = "Wiggly ears taken from a felled <#RED>{name.groak_elite}</>.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		--[[
		groak_chin =
		{
			name = "{name.groak} Chin",
			desc = "Found in: <#RED>{name.bandi_swamp}</>",
		},
		]]

		totolili_arm =
		{
			name = "{name.totolili} Arm",
			desc = "{name_multiple.totolili} hostility can be attributed to their lack of a funny bone.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		totolili_hat =
		{
			name = "{name.totolili_elite} Hat",
			desc = "Or is that its hair?\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		woworm_lip =
		{
			name = "{name.woworm} Head",
			desc = "Better than the other end.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		woworm_shield =
		{
			name = "{name.woworm_elite} Shell",
			desc = "Beware if you're in first place.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		swarmy_slime =
		{
			name = "{name.swarmy} Slime",
			desc = "A dollop of pure {name.swarmy}.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},
		swarmy_arm =
		{
			name = "{name.swarmy_elite} Arm",
			desc = "Great for practicing arm wrestling.\n\nFound in: <#RED>{name.bandi_swamp}</>",
		},

		--location specific items
		normal_treemon_forest =
		{
			name = "{name.treemon_forest} Twigs",
			desc = "",
		},

		imbued_treemon_forest =
		{
			name = "{name.treemon_forest} Leaf",
			desc = "",
		},

		boss_treemon_forest =
		{
			name = "{name.megatreemon} Claw",
			desc = "There's just no reason for trees to have thumbs.",
		},

		normal_owlitzer_forest =
		{
			name = "{name.owlitzer_forest} Seeds",
			desc = "",
		},

		imbued_owlitzer_forest =
		{
			name = "{name.owlitzer_forest} Fern",
			desc = "",
		},

		boss_owlitzer_forest =
		{
			name = "{name.owlitzer} Claw",
			desc = "The razor sharp claws of an <#RED>{name.owlitzer}</>.",
		},

		normal_bandi_swamp =
		{
			name = "{name.bandi_swamp} Moss",
			desc = "",
		},

		imbued_bandi_swamp =
		{
			name = "{name.bandi_swamp} Spore",
			desc = "",
		},

		boss_bandi_swamp =
		{
			name = "{name.bandicoot} Wing",
			desc = "Leathery wings with incredible tensile strength.",
		},

		normal_thatcher_swamp =
		{
			name = "{name.thatcher_swamp} Vines",
			desc = "",
		},

		imbued_thatcher_swamp =
		{
			name = "{name.thatcher_swamp} Slime",
			desc = "",
		},

		boss_thatcher_swamp =
		{
			name = "{name.thatcher} Husk",
			desc = "A solid shell.",
		},
	},

	BUILDINGS = {
		scout_tent =
		{
			name = "{name.station_scout}",
			desc = "Scouts congregate in this here tent. Ask round to track yourself a <#RED>{name.rot}</>.",
		},
		scout_tent_1 =
		{
			name = "{name.station_scout}",
			desc = "A hangout spot for scouts. Wrangle up information about any nearby {name_multiple.rot}.",
		},
		armorer =
		{
			name = "{name.station_armorsmith}",
			desc = "This shop will craft you up some armour.",
		},
		armorer_1 =
		{
			name = "{name.station_armorsmith}",
			desc = "A shop that crafts and sells armour.",
		},
		apothecary =
		{
			name = "{name.station_apothecary}",
			desc = "Potions, tinctures, and elixirs await stirring, stewing, and brewing.",
		},
		forge =
		{
			name = "{name.station_blacksmith}",
			desc = "Objects blunt and sharp alike get crafted up in here.",
		},
		forge_1 =
		{
			name = "{name.station_blacksmith}",
			desc = "A shop where you can get weapons crafted.",
		},
		chemist =
		{
			name = "{name.station_apothecary}",
			desc = "A potion smith is at the ready to concoct in their cauldrons.",
		},
		chemist_1 =
		{
			name = "{name.station_apothecary}",
			desc = "Enjoy yourself a potion? This alchemancer combines elixirs into desirable concoctions to you specs.",
		},
		kitchen =
		{
			name = "{name.station_cook}",
			desc = "Make delicious meals to prepare you for the journey ahead."
		},
		kitchen_1 =
		{
			name = "{name.station_cook}",
			desc = "Make delicious meals to prepare you for the journey ahead."
		},
		refinery_1 =
		{
			name = "{name.station_refiner}",
			desc = "Refine and Research Monster Materials."
		},
		refinery =
		{
			name = "{name.station_refiner}",
			desc = "Refine and Research Monster Materials."
		},

		dojo_1 = 
		{
			name = "{name.station_dojo}",
			desc = "Advance Masteries and learn to fight."
		},

		marketroom_shop = 
		{
			name = "{name.station_marketroom_shop}",
			desc = "",
		},
	},

	--[[BEAUTIFUL WRITER FRIENDS LOOK HERE:

		Here's a list of furniture words, feel free to grab from it or use them as a jumping off point :)
		It's okay to mix modern and medieval terms in our game.

		CHAIRS
		-Chair			-Stool
		-Seat			-Loveseat
		-Divan			-Armchair
		-Desk Chair 	-Rocking Chair
		-Recliner		-Wishbone Chair
		-Cushion

		BENCHES
		-Bench			-Pew
		-Lounge			-Chesterfield
		-Couch			-Sofa

		BEDS
		-Bed 			-Daybed
		-Futon			-Bunk
		-Mattress		-Tatami Mat
		-Bunk Bed 		-Four-Poster Bed
	]]

	STRUCTURES = {
		dummy_bandicoot =
		{
			name = "{name.bandicoot} Dummy",
			desc = "Relive that victory against the {name.bandicoot} while doing without the pesky wounds endured.",
		},
		dummy_cabbageroll =
		{
			name = "{name.cabbageroll} Dummy",
			desc = "Those <#RED>{name_multiple.cabbageroll}</> were a relentless bother. Vent your annoyance on a dummy of 'em!",
		},
		chair1 =
		{
			name = "Wooden Chair",
			desc = "Its mossy scent is temporary. Probably.",
		},
		chair2 =
		{
			name = "Hard Chair",
			desc = "Builds your tailbone's character",
		},
		bench_megatreemon =
		{
			name = "Mega Bench",
			desc = "Like a regular bench, but mega",
		},
		bench_rotwood =
		{
			name = "Bench",
			desc = "Like a chair, but double it",
		},
		hammock =
		{
			name = "Hammock",
			desc = "Get the best sleep of your life and the worst back pain",
		},
		kitchen_barrel =
		{
			name = "Barrel",
			desc = "It helps keep food fresh I think",
		},
		kitchen_chair =
		{
			name = "Kitchen Chair",
			desc = "Sit down when you're hungry",
		},
		
		outdoor_seating =
		{
			name = "Outdoor Seating",
			desc = "A chill place to chill.",
		},
		character_customizer_vshack =
		{
			name = "Vanity",
			desc = "Allows you to customize your character"
		},

		-- Basic Set + Dungeon-Specific Sets
		bench_basic =
		{
			name = "Hewn Bench",
			desc = "Just an old, reliable bench.",
		},
		chair_basic =
		{
			name = "Hewn Chair",
			desc = "A perfectly good wicker chair.",
		},
		street_lamp = 
		{
			name = "Mason Jar Lamp",
			desc = "You don't need to get fancy to make a place feel like home.",
		},
		lamp_basic =
		{
			name = "Hewn Lamp",
			desc = "Good for lighting garden paths.",
		},
		bed_basic =
		{
			name = "Hewn Cot",
			desc = "A decent spot to get some shut-eye."
		},
		outdoor_seating_basic =
		{
			name = "Hewn 'Brelly Table",
			desc = "A content place to drink your morning brew."
		},
		stool_outdoor_seating_basic =
		{
			name = "Hewn Stool",
			desc = "That right there's a stool for sittin'.",
		},

		-- Megatreemon
		bench_forest_1 =
		{
			name = "Woodland Bench",
			desc = "There's cobwebs lurking beneath the pillow.",
		},
		chair_forest_1 =
		{
			name = "Woodland Chair",
			desc = "The underside houses a bustling community of happy pillbugs.",
		},
		lamp_forest_1 =
		{
			name = "Woodland Pathway Light",
			desc = "A shining beacon for both moths and crane flies.",
		},
		bed_forest_1 =
		{
			name = "Woodland Bed",
			desc = "The comforter is always slightly damp with dew."
		},
		outdoor_seating_forest_1 =
		{
			name = "Woodland Garden Table",
			desc = "Cozy, but the table runner is dotted with old pine needles."
		},
		stool_outdoor_seating_forest_1 =
		{
			name = "Woodland Stool",
			desc = "Always gets your butt wet, even when it looks dry.",
		},

		-- Owlitzer
		bench_forest_2 =
		{
			name = "Chiseled Bench",
			desc = "Sitting on it fills you with a chill, reminiscent of the grove.",
		},
		chair_forest_2 =
		{
			name = "Chiseled Chair",
			desc = "Yes, your butt will be sore.",
		},
		lamp_forest_2 =
		{
			name = "Chiseled Lantern",
			desc = "To light your way in the perpetual twilight.",
		},
		bed_forest_2 =
		{
			name = "Chiseled Nest",
			desc = "Just close your eyes and pretend you're a warm, happy egg."
		},
		outdoor_seating_forest_2 =
		{
			name = "Chiseled 'Brelly Table",
			desc = "Relax in the shade and pretend you're in <#BLUE>{name.owlitzer_forest}</>."
		},
		stool_outdoor_seating_forest_2 =
		{
			name = "Chiseled Stool",
			desc = "Step stool? Foot stool? Sitting stool?\nThe possibilities are endless.",
		},

		-- Bandicoot
		bench_swamp_1 =
		{
			name = "Boggy Chaise Lounge",
			desc = "You'll faint cozily onto it after getting that whiff of bog stench.",
		},
		chair_swamp_1 =
		{
			name = "Boggy Wingback Chair",
			desc = "Perfectly remembers the shape of the butt that last sat on it.",
		},
		lamp_swamp_1 =
		{
			name = "Boggy Candelabra",
			desc = "Light your town with that signature <#BLUE>Blisterbane</> glow.",
		},
		bed_swamp_1 =
		{
			name = "Boggy Bed",
			desc = "Schlorp yourself into bed and curl up in a nice slime mould blankie."
		},
		outdoor_seating_swamp_1 =
		{
			name = "Boggy Courtyard Table",
			desc = "Block out that harsh sun with this perfectly repurposed 'shroom.",
		},
		stool_outdoor_seating_swamp_1 =
		{
			name = "Boggy Foot Rest",
			desc = "Kick up your feet after a long day's Hunt.",
		},

		-- Thatcher
		bench_swamp_2 =
		{
			name = "Fen Garden Bench",
			desc = "Take a seat, it's nice and squishy.",
		},
		chair_swamp_2 =
		{
			name = "Fen Swivel Chair",
			desc = "Weee!",
		},
		lamp_swamp_2 =
		{
			name = "Fen Reading Lamp",
			desc = "Do a lil reading, under a lily.",
		},
		bed_swamp_2 =
		{
			name = "Fen Bed",
			desc = "Sleep like a distinguished froggy gentleman under your lily pad blanket.",
		},
		outdoor_seating_swamp_2 =
		{
			name = "Fen 'Brelly Table",
			desc = "The umbrella's more about style than function.",
		},
		stool_outdoor_seating_swamp_2 =
		{
			name = "Fen Stool",
			desc = "Mushroom-shaped and perfect for a toad to sit on.",
		},

		fence_stone =
		{
			name = "Stone Wall",
			desc = "Give your town the pastoral look.",
		},
		r_fence_stone =
		{
			name = "Stone Wall (R)",
			desc = "The right facing L-piece for a Stone Wall.",
		},
		l_fence_stone =
		{
			name = "Stone Wall (L)",
			desc = "The left facing L-piece for a Stone Wall.",
		},

		fence_iron =
		{
			name = "Iron Fence",
			desc = "Now look what you've wrought.",
		},
		r_fence_iron =
		{
			name = "Iron Fence (R)",
			desc = "The right facing L-piece for an Iron Fence.",
		},
		l_fence_iron =
		{
			name = "Iron Fence (L)",
			desc = "The left facing L-piece for an Iron Fence.",
		},

		rugged_weapon_rack =
		{
			name = "Rustic Weapon Rack",
			desc = "Comes complete with two decorative spears and an equally decorative greatsword.",
		},
		rustic_weapon_rack =
		{
			name = "Rugged Weapon Rack",
			desc = "Decorative greatsword, hammer and spear included.",
		},

		bread_basket =
		{
			name = "Bread Basket",
			desc = "Comes with unlimited refills.\nToo bad you can't eat it.",
		},
		fruit_basket =
		{
			name = "Fruit Basket",
			desc = "Are those real?",
		},
		straw_wooden_cart =
		{
			name = "Straw Cart",
			desc = "Looks like a delightful (if itchy) place to nap.",
		},
		wood_wooden_cart =
		{
			name = "Wood Cart",
			desc = "Gotta haul logs around somehow.",
		},
		hammock_basic =
		{
			name = "Lazy Hammock",
			desc = "Just relax.",
		},

		megatreemon_town_bossstatue = 
		{
			name = "Idol of {name.megatreemon}",
			desc = "May she watch over us as she once watched over the forest.",
		},

		owlitzer_town_bossstatue = 
		{
			name = "Idol of {name.owlitzer}",
			desc = "A place to hold night vigil for a worthy adversary.",
		},

		bandicoot_town_bossstatue = 
		{
			name = "Idol of {name.bandicoot}",
			desc = "May she share her cunning, if only in spirit.",
		},

		thatcher_town_bossstatue = 
		{
			name = "Idol of {name.thatcher}",
			desc = "Memorialized as a rock idol.\nJust as they would have wanted.",
		},
	},

	DECOR = {
		--PLUSHIES--
		------------------------------------------------------------------------
		plushies_stack =
		{
			name = "Plushie Pile",
			desc = "It's BEGGING you to jump in.",
		},

		--BOSSES
		thatcher_lrg_plushies =
		{
			name = "{name.thatcher} Plushie",
			desc = "It's <#RED>{NAME.thatcher}</>, the fuzzy bug that really rocks!\n<z 0.8>(Guitar-Scythe sold separately, batteries not included.)</>",
		},
		megatreemon_lrg_plushies =
		{
			name = "{name.megatreemon} Plushie",
			desc = "She's the little <#RED>{name_multiple.treemon}'</> mama.",
		},
		owlitzer_lrg_plushies =
		{
			name = "{name.owlitzer} Plushie",
			desc = "It has a little pocket under the scruff to hold dried lavender.",
		},
		bandicoot_lrg_plushies =
		{
			name = "{name.bandicoot} Plushie",
			desc = "Who's laughing now?",
		},

		--MINIBOSSES
		yammo_mid_plushies =
		{
			name = "{name.yammo} Plushie",
			desc = "Not so threatening now, is it?",
		},
		gourdo_mid_plushies =
		{
			name = "{name.gourdo} Plushie",
			desc = "A chunky boy who gives great hugs.", wooden_cart =
		{
			name = "Wooden Cart",
			desc = "Take a pleasant ride, once you're finally awake.",
		},
		},
		zucco_sm_plushies =
		{
			name = "{name.zucco} Plushie",
			desc = "Look'it that stout lil sauerkraut!",  
		},
		trio_mid_plushies =
		{
			name = "Rotrioshka",
			desc = "It's <#RED>{name_multiple.rot}</>, all the way down.",
		},
		floracrane_mid_plushies =
		{
			name = "{name.floracrane} Plushie",
			desc = "Doubles as a cozy scarf.",  
		},
		groak_mid_plushies =
		{
			name = "{name.groak} Plushie",
			desc = "A charming lad who really draws you in.",  
		},

		--REGULAR ROTS
		--great rotwood forest
		beets_sm_plushies =
		{
			name = "{name.beets} Plushie",
			desc = "There it is. The perfect little guy.",  
		},
		cabbageroll_sm_plushies =
		{
			name = "{name.cabbageroll} Plushie",
			desc = "Don't forget to SMILE!",  
		},		
		blarmadillo_sm_plushies =
		{
			name = "{name.blarmadillo} Plushie",
			desc = "Shhh! She's sleeping.",  
		},
		treemon_sm_plushies =
		{
			name = "{name.treemon} Plushie",
			desc = "Go on, hug it. It'd be rude not to.",  
		},

		--owl forest
		gnarlic_sm_plushies =
		{
			name = "{name.gnarlic} Plushie",
			desc = "Cute? Yes. Evil? Maybe.",  
		},
		battoad_sm_plushies =
		{
			name = "{name.battoad} Plushie",
			desc = "Its stuffing is nice and lumpy.",  
		},
		windmon_mid_plushies =
		{
			name = "{name.windmon} Plushie",
			desc = "Loves to be hung out the open window on roadtrips.",
		},

		--bandicoot swamp
		mothball_sm_plushies =
		{
			name = "{name.mothball} Plushie",
			desc = "Stuffed with real <#RED>{name.mothball}</>!",  
		},
		mothball_teen_mid_plushies =
		{
			name = "{name.mothball_teen} Plushie",
			desc = "Little <#RED>{name.mothball}'s</> big bro.",  
		},
		bulbug_sm_plushies =
		{
			name = "{name.bulbug} Plushie",
			desc = "Now <i>that's</i> a snugglebug.",  
		},
		eyev_sm_plushies =
		{
			name = "{name.eyev} Plushie",
			desc = "This stuffed friend will keep an eye on you.",  
		},
		mossquito_sm_plushies =
		{
			name = "{name.mossquito} Plushie",
			desc = "You can prank someone pretty good by hiding it in a fruit basket.",  
		},
		sporemon_sm_plushies =
		{
			name = "{name.sporemon} Plushie",
			desc = "It rattles when shaken.",
		},

		--thatcher swamp
		slowpoke_mid_plushies =
		{
			name = "{name.slowpoke} Plushie",
			desc = "This <#RED>{name.slowpoke}'s</> bellyflops are more than welcome.",  
		},
		woworm_mid_plushies =
		{
			name = "{name.woworm} Plushie",
			desc = "What a snuggly snail!",  
		},
		swarmy_sm_plushies =
		{
			name = "{name.swarmy} Plushie",
			desc = "Machine washable, unlike the real thing.",
		},
		totolili_mid_plushies =
		{
			name = "{name.totolili} Plushie",
			desc = "Real wire-posable arms!",
		},


		--REGULAR DECOR ITEMS--
		------------------------------------------------------------------------
		wooden_cart =
		{
			name = "Wooden Cart",
			desc = "Take a pleasant ride, once you're finally awake.",
		},
		town_flower_bush =
		{
			name = "Bush Flower",
			desc = "Native wildflowers with a sweet scent.",
		},
		town_flower_violet =
		{
			name = "Violets",
			desc = "Little purple flowers.\nNothing more, or less.",
		},
		town_flower_coralbell =
		{
			name = "Coral Bells",
			desc = "A luscious, purple plant.\nRequires no watering.",
		},
		town_flower_bluebell =
		{
			name = "Bluebells",
			desc = "A blue flower shaped like a bell.",
		},
		pergola =
		{
			name = "Pergola",
			desc = "Rest a moment in the shade.\nYou deserve it.",
		},
		tree =
		{
			name = "Tree",
			desc = "It's a tree.",
		},
		town_shrub =
		{
			name = "Bush",
			desc = "A healthy shrub, free of <#KONJUR>{name.konjur}</> contamination.",
		},
		basket =
		{
			name = "Woven Basket",
			desc = "Handwoven by delicate paws.",
		},
		bulletin_board =
		{
			name = "Bulletin Board",
			desc = "A place to post notices.",
		},
		bread_oven =
		{
			name = "Bread Oven",
			desc = "Smells delicious, even when it's not burning.",
		},
		dye1 =
		{
			name = "Barrel of Dye",
			desc = "Colorful",
		},
		dye2 =
		{
			name = "Barrel of Dye",
			desc = "Colorful",
		},
		dye3 =
		{
			name = "Barrel of Dye",
			desc = "Colorful",
		},
		kitchen_sign =
		{
			name = "Kitchen Sign",
			desc = "In case you don't know where the kitchen is",
		},
		leather_rack =
		{
			name = "Leather Rack",
			desc = "Kinda dry",
		},
		tanning_rack =
		{
			name = "Tanning Rack",
			desc = "Kinda Tan",
		},
		stone_lamp =
		{
			name = "Stone Lamp",
			desc = "Let there be light",
		},
		street_lamp =
		{
			name = "Street Lamp",
			desc = "Lux Aeterna",
		},
		travel_pack =
		{
			name = "Travel Pack",
			desc = "Everything you need in one place",
		},
		weapon_rack =
		{
			name = "Weapon Rack",
			desc = "Do I need a permit for those?",
		},
		well =
		{
			name = "Water Well",
			desc = "Well, well, well, what do we have here?",
		},
	},

	BIOME_EXPLORATION =
	{
		treemon_forest =
		{
			name = "{name.treemon_forest} Exploration",
			desc = "Advance through expeditions to the <#RED>{name.treemon_forest}</>",
		},
		owlitzer_forest =
		{
			name = "{name.owlitzer_forest} Exploration",
			desc = "Advance through expeditions to the <#RED>{name.owlitzer_forest}",
		},

		bandi_swamp =
		{
			name = "{name.bandi_swamp} Exploration",
			desc = "Advance through expeditions to <#RED>{name.bandi_swamp}</>",
		},
		thatcher_swamp =
		{
			name = "{name.thatcher_swamp} Exploration",
			desc = "Advance through expeditions to <#RED>{name.thatcher_swamp}</>",
		},

		sedament_tundra =
		{
			name = "{name.sedament_tundra} Exploration",
			desc = "Advance through expeditions to <#RED>{name.sedament_tundra}</>",
		},
	},

	KONJUR_CONVERSION =
	{
		basic =
		{
			name = "{name.konjur} Conversion",
			desc = "Convert {name.konjur} into {name.konjur_soul_lesser}."
		},
	},

	WEAPON_UNLOCKS =
	{
		hammer =
		{
			name = "{name.weapon_hammer} Unlock",
			desc = "Unlock the ability to use a {name.weapon_hammer}."
		},
		polearm =
		{
			name = "{name.weapon_polearm} Unlock",
			desc = "Unlock the ability to use a {name.weapon_polearm}."
		},
		shotput =
		{
			name = "{name.weapon_shotput} Unlock",
			desc = "Unlock the ability to use a {name.weapon_shotput}."
		},
		cannon =
		{
			name = "{name.weapon_cannon} Unlock",
			desc = "Unlock the ability to use a {name.weapon_cannon}."
		},
	},

	MONSTER_RESEARCH =
	{
		--Can we make this happen codeside? So just {idname} + "Research" instead? --Kris

		-- forest
		beets =
		{
			name = "{name.beets} {name.research}",
			desc = "Advanced <#BLUE>{name.beets} {name.research}</> for more efficient use of <#RED>{name.beets}</> materials.",
		},
		gnarlic =
		{
			name = "{name.gnarlic} {name.research}",
			desc = "Advanced <#BLUE>{name.gnarlic} {name.research}</> for more efficient use of <#RED>{name.gnarlic}</> materials.",
		},
		cabbageroll =
		{
			name = "{name.cabbageroll} {name.research}",
			desc = "Advanced <#BLUE>{name.cabbageroll} {name.research}</> for more efficient use of <#RED>{name.cabbageroll}</> materials.",
		},

		blarmadillo =
		{
			name = "{name.blarmadillo} {name.research}",
			desc = "Advanced <#BLUE>{name.blarmadillo} {name.research}</> for more efficient use of <#RED>{name.blarmadillo}</> materials.",
		},
		zucco =
		{
			name = "{name.zucco} {name.research}",
			desc = "Advanced <#BLUE>{name.zucco} {name.research}</> for more efficient use of <#RED>{name.zucco}</> materials.",
		},
		yammo =
		{
			name = "{name.yammo} {name.research}",
			desc = "Advanced <#BLUE>{name.yammo} {name.research}</> for more efficient use of <#RED>{name.yammo}</> materials.",
		},
		gourdo =
		{
			name = "{name.gourdo} {name.research}",
			desc = "Advanced <#BLUE>{name.gourdo} {name.research}</> for more efficient use of <#RED>{name.gourdo}</> materials.",
		},
		eyev =
		{
			name = "{name.eyev} {name.research}",
			desc = "Advanced <#BLUE>{name.eyev} {name.research}</> for more efficient use of <#RED>{name.eyev}</> materials.",
		},
		treemon =
		{
			name = "{name.treemon} {name.research}",
			desc = "Advanced <#BLUE>{name.treemon} {name.research}</> for more efficient use of <#RED>{name.treemon}</> materials.",
		},
		megatreemon =
		{
			name = "{name.megatreemon} {name.research}",
			desc = "Advanced <#BLUE>{name.megatreemon} {name.research}</> for more efficient use of <#RED>{name.megatreemon}</> materials.",
		},
		owlitzer =
		{
			name = "{name.owlitzer} {name.research}",
			desc = "Advanced <#BLUE>{name.owlitzer} {name.research}</> for more efficient use of <#RED>{name.owlitzer}</> materials.",
		},

		-- swamp

		mothball =
		{
			name = "{name.mothball} {name.research}",
			desc = "Advanced <#BLUE>{name.mothball} {name.research}</> for more efficient use of <#RED>{name.mothball}</> materials.",
		},
		battoad =
		{
			name = "{name.battoad} {name.research}",
			desc = "Advanced <#BLUE>{name.battoad} {name.research}</> for more efficient use of <#RED>{name.battoad}</> materials.",
		},
		floracrane =
		{
			name = "{name.floracrane} {name.research}",
			desc = "Advanced <#BLUE>{name.floracrane} {name.research}</> for more efficient use of <#RED>{name.floracrane}</> materials.",
		},
		bulbug =
		{
			name = "{name.bulbug} {name.research}",
			desc = "Advanced <#BLUE>{name.bulbug} {name.research}</> for more efficient use of <#RED>{name.bulbug}</> materials.",
		},
		mossquito =
		{
			name = "{name.mossquito} {name.research}",
			desc = "Advanced <#BLUE>{name.mossquito} {name.research}</> for more efficient use of <#RED>{name.mossquito}</> materials.",
		},
		groak =
		{
			name = "{name.groak} {name.research}",
			desc = "Advanced <#BLUE>{name.groak} {name.research}</> for more efficient use of <#RED>{name.groak}</> materials.",
		},
		slowpoke =
		{
			name = "{name.slowpoke} {name.research}",
			desc = "Advanced <#BLUE>{name.slowpoke} {name.research}</> for more efficient use of <#RED>{name.slowpoke}</> materials.",
		},
		bandicoot =
		{
			name = "{name.bandicoot} {name.research}",
			desc = "Advanced <#BLUE>{name.bandicoot} {name.research}</> for more efficient use of <#RED>{name.bandicoot}</> materials.",
		},
	},

	DEFAULT_UNLOCK =
	{
		default =
		{
			name = "default data",
			desc = "no one should ever read this string in the game",
		}
	},

	RELATIONSHIP_CORE =
	{

	},

	WEAPON_MASTERY =
	{

		-- ALL TEMP

		----- HAMMER -----
		GENERAL =
		{
			perfect_dodge =
			{
				name = "Perfect Dodge",
				desc = "<#RED>Dodge</> an <#RED>Attack</> at the last second, leaving a cloud of dust.",
			},
			quick_rise =
			{
				name = "Quick Rise",
				desc = "When getting <#RED>Knocked Down</>, <#RED>Dodge</> as you hit the ground to avoid staying down.",
			},
			dodge_cancel =
			{
				name = "Dodge Cancel",
				desc = "<#RED>Dodge</> during the recovery of an <#RED>Attack</>.",
			},
			dodge_cancel_on_hit =
			{
				name = "Dodge Cancel Advanced",
				desc = "<#RED>Dodge Cancel</> during the recovery of an <#RED>Attack</> that hit an enemy.",
			},
			dodge_cancel_perfect =
			{
				name = "Perfect Dodge Cancel",
				desc = "<#RED>Dodge Cancel</> to evade an incoming <#RED>Attack</> at the last second.",
			},
			dodge_cancel_hitstreak =
			{
				name = "Dodge Cancel Hit Streak",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat that includes <#RED>{dodgecancels} Dodge Cancels</>.",
			},
			hitstreak_perfect_dodge =
			{
				name = "Perfect Dodge Cancel Hit Streak",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat that includes a <#RED>Perfect Dodge Cancel</>.",
			},
			hitstreak_props =
			{
				name = "Environmental Hit Streak",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat that includes {num_prophits} hits against Environmental Objects.",
			},
			critical_hit =
			{
				name = "Critical Hit",
				desc = "Deal a <#ATK_CRIT>Critical Hit</> during combat. Increase your <#RED>Critical Hit Chance</> using {name_multiple.concept_relic}.",
			},
		},

		HAMMER =
		{
			-- Focus Hits
			hammer_focus_multiple_targets =
			{
				name = "Multiple Target {name_multiple.concept_focus_hit}",
				desc = "Hit multiple targets at once to deal more damage with a <#BLUE>{name.concept_focus_hit}</>.",
			},
			hammer_air_spin =
			{
				name = "Combo {name_multiple.concept_focus_hit}",
				desc = "Hit a target with a <#RED>Jumping Heavy Somersault</> (<p bind='Controls.Digital.ATTACK_LIGHT'> <p bind='Controls.Digital.ATTACK_LIGHT'>, hold <p bind='Controls.Digital.ATTACK_HEAVY'>) to get a <#BLUE>{name.concept_focus_hit}</>.",
			},
			hammer_focus_hits =
			{
				name = "{name.weapon_hammer} {name_multiple.concept_focus_hit}",
				desc = "Kill an enemy using any <#BLUE>{name.concept_focus_hit}</>.",
			},
			hammer_focus_hits_destructibles =
			{
				name = "Collateral Damage",
				desc = "Get a <#BLUE>{name.concept_focus_hit}</> by hitting an <#RED>Environmental Object</> and an enemy at the same time.", --kris
			},

			hammer_hitstreak_basic =
			{
				name = "Basic Hitstreaks",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat.",
			},
			hammer_hitstreak_advanced =
			{
				name = "Advanced Hitstreaks",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat.",
			},


			-- BASIC MOVES
			hammer_fading_light =
			{
				name = "Fading Lights",
				desc = "Kill an enemy with a <#RED>Fading Light</>.", --TODO controls
			},
			hammer_thump =
			{
				name = "Order in the Court",
				desc = "Hit at least {enemies} enemies with a fully charged <#RED>Order in the Court</> Skill.",
			},
			hammer_golf_swing =
			{
				name = "Golf Swings",
				desc = "Hit at least {enemies} enemies with a fully charged <#RED>Golf Swing</> (<p bind='Controls.Digital.DODGE'> <p img='images/ui_ftf/arrow_right.tex' scale=0.4> hold Backwards <p bind='Controls.Digital.ATTACK_HEAVY'>).", --TODO controls
			},

			hammer_lariat =
			{
				name = "Spinning Heavy Lariat",
				desc = "Kill an enemy with a <#RED>Spinning Heavy Lariat</>.", --TODO controls
			},

			hammer_heavy_slam =
			{
				name = "Standing Heavy Slam",
				desc = "Kill an enemy with a <#RED>Standing Heavy Slam</>.", --TODO controls
			},

			hammer_counterattack =
			{
				name = "Counter Attacks",
				desc = "Kill an enemy while it is in the middle of an <#RED>Attack</>.",
			},

			-- ADVANCED MOVES
			hammer_hitstreak_dodge_L =
			{
				name = "Hitstreak with Rolling Lights",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat starting with a <#RED>Rolling Light Attack</>.",
			},

			hammer_hitstreak_fading_L =
			{
				name = "Hitstreak with Fading Light",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat using at least <#RED>{fading_lights} Fading Light Attacks</> (<p bind='Controls.Digital.DODGE'> <p img='images/ui_ftf/arrow_right.tex' scale=0.4> Backwards <p bind='Controls.Digital.ATTACK_LIGHT'>).",
			},
		},

		----- POLEARM -----
		POLEARM =
		{
			polearm_focus_hits_tip =
			{
				name = "Tipped {name_multiple.concept_focus_hit}",
				desc = "Hit a target with the tip of your Spear to deal more damage as a <#BLUE>{name.concept_focus_hit}</>.", --TODO
			},

			polearm_drill_multiple_enemies_basic =
			{
				name = "Spinning Drill {name_multiple.concept_focus_hit}",
				desc = "Hit multiple targets with a <#RED>Spinning Drill</> (<p bind='Controls.Digital.DODGE'>  <p img='images/ui_ftf/arrow_right.tex' scale=0.4>  <p bind='Controls.Digital.ATTACK_LIGHT'>) to deal more damage with a <#BLUE>{name.concept_focus_hit}</>.", --TODO controls
			},
			polearm_focus_kills =
			{
				name = "{name.weapon_polearm} {name_multiple.concept_focus_hit}",
				desc = "Kill an enemy using any <#BLUE>{name.concept_focus_hit}</>.",
			},
			polearm_multithrust_focus =
			{
				name = "Multi-thrust Focus Hits",
				desc = "Hit a target with a <#RED>Multi-thrust</> (<p bind='Controls.Digital.ATTACK_LIGHT'> <p bind='Controls.Digital.ATTACK_LIGHT'> <p bind='Controls.Digital.ATTACK_LIGHT'> <p bind='Controls.Digital.ATTACK_HEAVY'>) where all {num_hits} hits connect with the tip of the Spear.",
			},
			polearm_shove_counterattack =
			{
				name = "Cross Counter",
				desc = "Hit an enemy with the <#RED>Crosscheck</> Skill (<p bind='Controls.Digital.SKILL'>) while it is in the middle of an <#RED>Attack</>.",
			},

			polearm_single_hit =
			{
				name = "One and Done",
				desc = "Kill an enemy with a single <#RED>Attack</>.", --TODO controls
			},


			polearm_fading_light =
			{
				name = "Fading Lights",
				desc = "Kill an enemy with a <#RED>Fading Light</>.", --TODO controls
			},

			polearm_drill =
			{
				name = "Spinning Drill",
				desc = "Kill an enemy with a <#RED>Spinning Drill</>.", --TODO controls
			},

			polearm_multithrust =
			{
				name = "Multi-Thrust",
				desc = "Kill an enemy with a <#RED>Multi-thrust</>.", --TODO controls
			},

			polearm_heavy_attack =
			{
				name = "Jumping Heavy",
				desc = "Kill an enemy with a <#RED>Jumping Heavy</>.", --TODO controls
			},

			polearm_drill_multiple_enemies_advanced =
			{
				name = "Spinning Drill x5",
				desc = "Hit {num_enemies} targets with a single <#RED>Spinning Drill</>.", --TODO controls
			},

			polearm_hitstreak_basic =
			{
				name = "Hitstreak Basic",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat.", --TODO controls
			},

			polearm_hitstreak_advanced =
			{
				name = "Drill Hitstreak Advanced",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat featuring at least <#RED>{num_drills} Spinning Drills</> (<p bind='Controls.Digital.DODGE'>  <p img='images/ui_ftf/arrow_right.tex' scale=0.4>  <p bind='Controls.Digital.ATTACK_LIGHT'>).", --TODO controls
			},

			polearm_hitstreak_expert =
			{
				name = "Drill Hitstreak Expert",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat.", --TODO
			},
		},

		CANNON =
		{
			cannon_perfect_reload =
			{
				name = "Perfect Reload",
				desc = "Press <p bind='Controls.Digital.DODGE'> <p bind='Controls.Digital.DODGE'> with good timing to <#RED>Reload</> quickly.",
			},
			cannon_butt_reload =
			{
				name = "Praetor Reload",
				desc = "Hit a target with the <#RED>Battering Ram</> Skill (<p bind='Controls.Digital.SKILL'>) to regain <#RED>1 {name.cannon_ammo}</>.",
			},
			cannon_perfect_dodge =
			{
				name = "Perfect Dodge",
				desc = "Press <p bind='Controls.Digital.ATTACK_HEAVY'> to <#RED>Dodge</> an <#RED>Attack</> at the last second, leaving a cloud of dust.",
			},
			cannon_quick_rise =
			{
				name = "Quick Rise",
				desc = "When getting knocked down, press <p bind='Controls.Digital.ATTACK_HEAVY'> to <#RED>Dodge</> as you hit the ground to avoid staying down.",
			},
			cannon_focus =
			{
				name = "Focus Shots",
				desc = "Shoot a target with the last half of your ammo clip to get a <#BLUE>Focus Hit</>.",
			},
			cannon_focus_shockwave =
			{
				name = "Focus Shockwave",
				desc = "Create a <#RED>Shockwave</> (<p bind='Controls.Digital.DODGE'> <p img='images/ui_ftf/arrow_right.tex' scale=0.4> <p bind='Controls.Digital.ATTACK_LIGHT'>) with the last half of your ammo clip to get a <#BLUE>Focus Hit</> on an enemy.",
			},

			cannon_hitstreak_basic =
			{
				name = "Basic Hitstreaks",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat.",
			},
			cannon_hitstreak_heavy =
			{
				name = "Skilled Hitstreaks",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat featuring at least <#RED>{num_butts} Battering Ram</> Skills and <#RED>{num_heavyhits} Heavy Attack</> pellets.",
			},
			cannon_hitstreak_advanced =
			{
				name = "Advanced Hitstreaks",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat.",
			},
		},

		SHOTPUT =
		{
			shotput_focus_thrown =
			{
				name = "A Deadly Rhythm",
				desc = "Throw (<p bind='Controls.Digital.ATTACK_HEAVY'>) a <#RED>Striker</> as you catch it to get a <#BLUE>{name.concept_focus_hit}</>.",
			},

			shotput_focus_spiked =
			{
				name = "Return to Sender",
				desc = "Hit (<p bind='Controls.Digital.ATTACK_LIGHT'>) an airborne <#RED>Striker</> into a target to get a <#BLUE>{name.concept_focus_hit}</>.",
			},

			shotput_focus_kills =
			{
				name = "Surprise Headers",
				desc = "Kill an enemy using any <#BLUE>{name.concept_focus_hit}</>.",
			},

			shotput_focus_rebound =
			{
				name = "Two Birds, one Striker",
				desc = "Let a <#RED>Striker</> land on a target to get a <#BLUE>{name.concept_focus_hit}</>.",
			},

			shotput_recall = -- Skill Mastery
			{
				name = "Pass!",
				desc = "Kill an enemy with a <#RED>Striker</> that you <#RED>Recalled</> (<p bind='Controls.Digital.SKILL'> or <p bind='Controls.Digital.ATTACK_HEAVY'>).",
			},

			shotput_juggle_melee_kill = -- Challenge Mastery
			{
				name = "Audience Interference",
				desc = "Kill an enemy with a <#RED>Melee Attack</> while at least one of your <#RED>Strikers</> is airborne.",
			},

			-- Hitstreak Masteries

			shotput_hitstreak_basic =
			{
				name = "Basic Hitstreaks",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat.",
			},

			shotput_hitstreak_melee =
			{
				name = "Into the Fray",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat that includes at least <#RED>{melee} Melee</> hits and <#RED>{striker} Striker</> hits.",
			},

			shotput_hitstreak_master =
			{
				name = "Masterful Hitstreaks",
				desc = "Get a <#RED>{hitstreak}+ Hit Streak</> during combat.",
			},

			-- Hidden Masteries


			shotput_juggle_10 =
			{
				name = "Master Juggler",
				desc = "Get a <#RED>Juggle</> streak of 10 by <#RED>Throwing</> or <#RED>Spiking</> your <#RED>Strikers</> without stopping or letting them touch the ground.",
			},

			shotput_spiked_kick_knockdown =
			{
				name = "Poor Sportsmanship",
				desc = "Kill an enemy using a <#BLUE>Focus Hit</> by kicking (<p bind='Controls.Digital.DODGE'> + <p img='images/ui_ftf/arrow_left.tex' scale=0.4> + <p bind='Controls.Digital.ATTACK_LIGHT'>) a <#RED>Rebounding</> <#RED>Striker</> at the peak of your kick.",
			},

			shotput_hitstreak_recall =
			{
				name = "Pass!",
				desc = "Get a <#RED>20+ Hit Streak</> during combat that includes at least 2 <#RED>Recall</> (<p bind='Controls.Digital.SKILL'> or <p bind='Controls.Digital.ATTACK_HEAVY'>) hits.",
			},
		},
	},

	MONSTER_MASTERY =
	{
		OTHER =
		{
			megatreemon_kill =
			{
				name = "{name.megatreemon} Kill",
				desc = "Kill the {name.megatreemon}.",
			},
			megatreemon_kill_ascension_1 =
			{
				name = "{name.megatreemon} {name.ascension} 1",
				desc = "Kill the {name.megatreemon} at {name.ascension} 1.",
			},
			megatreemon_kill_ascension_2 =
			{
				name = "{name.megatreemon} {name.ascension} 2",
				desc = "Kill the {name.megatreemon} at {name.ascension} 2.",
			},
			megatreemon_kill_ascension_3 =
			{
				name = "{name.megatreemon} {name.ascension} 3",
				desc = "Kill the {name.megatreemon} at {name.ascension} 3.",
			},
			owlitzer_kill =
			{
				name = "{name.owlitzer} Kill",
				desc = "Kill the {name.owlitzer}.",
			},
			owlitzer_kill_ascension_1 =
			{
				name = "{name.owlitzer} {name.ascension} 1",
				desc = "Kill the {name.owlitzer} at {name.ascension} 1.",
			},
			owlitzer_kill_ascension_2 =
			{
				name = "{name.owlitzer} {name.ascension} 2",
				desc = "Kill the {name.owlitzer} at {name.ascension} 2.",
			},
			owlitzer_kill_ascension_3 =
			{
				name = "{name.owlitzer} {name.ascension} 3",
				desc = "Kill the {name.owlitzer} at {name.ascension} 3.",
			},
			bandicoot_kill =
			{
				name = "{name.bandicoot} Kill",
				desc = "Kill the {name.bandicoot}.",
			},
			bandicoot_kill_ascension_1 =
			{
				name = "{name.bandicoot} {name.ascension} 1",
				desc = "Kill the {name.bandicoot} at {name.ascension} 1.",
			},
			bandicoot_kill_ascension_2 =
			{
				name = "{name.bandicoot} {name.ascension} 2",
				desc = "Kill the {name.bandicoot} at {name.ascension} 2.",
			},
			bandicoot_kill_ascension_3 =
			{
				name = "{name.bandicoot} {name.ascension} 3",
				desc = "Kill the {name.bandicoot} at {name.ascension} 3.",
			},
			thatcher_kill =
			{
				name = "{name.thatcher} Kill",
				desc = "Kill the {name.thatcher}.",
			},
			thatcher_kill_ascension_1 =
			{
				name = "{name.thatcher} {name.ascension} 1",
				desc = "Kill the {name.thatcher} at {name.ascension} 1.",
			},
			thatcher_kill_ascension_2 =
			{
				name = "{name.thatcher} {name.ascension} 2",
				desc = "Kill the {name.thatcher} at {name.ascension} 2.",
			},
			thatcher_kill_ascension_3 =
			{
				name = "{name.thatcher} {name.ascension} 3",
				desc = "Kill the {name.thatcher} at {name.ascension} 3.",
			},
		},
	},

	GEMS = {

		LEVEL_UP_NOTIFICATION = "{gem_name} Level Up!!!",

		ILVL_TO_NAME =
		-- usage to find suffix = ILVL_TO_NAME[gem:GetEffectiveItemLevel()] returns the correct suffix
		{
			"α", --1
			"β", --2
			"γ", --3
			"Σ", --4
			"Ω", --5
		},

		PROTOTYPE_DESC_TUTORIAL = "Slot into a <#RED>Weapon</> at the <#RED>{name.station_gems}</>, located by {name.npc_blacksmith}.",

		damage_mod =
		{
			-- Adds a flat damage boost
			name = "Damage Bonus {name.gem}",
			desc = "Its razor sharp edges could cause injury if not handled with care.\n\nIncreases <#RED>Weapon {name.concept_damage}</>.\n\n<#RED>{name_multiple.gem}</> can be set into <#RED>Weapons</> by {name.npc_blacksmith}.",
			--at the <#RED>{name.station_gems}</>, located near {name.npc_blacksmith}.",
			slotted_desc = "Increases <#RED>Weapon {name.concept_damage}</>.",
			stat_name = "Bonus <#RED>{name.concept_damage}</>",
		},

		-- damage_mult =
		-- {
		-- 	-- Adds a % damage boost
		-- 	name = "Damage Percentage",
		-- 	desc = "Increase <#RED>Damage</> by a percentage.",
		-- },

		damage_crit =
		{
			name = "Critical Damage {name.gem}",
			desc = "Fire appears trapped inside when held up to the sun.\n\nIncreases <#RED>Critical Hit {name.concept_damage}</>.\n\n<#RED>{name_multiple.gem}</> can be set into <#RED>Weapons</> by {name.npc_blacksmith}.",
			--at the <#RED>{name.station_gems}</>, located near {name.npc_blacksmith}.",
			slotted_desc = "Increases <#RED>Critical Hit {name.concept_damage}</>.",
		},

		damage_focus =
		{
			name = "Focus Damage {name.gem}",
			desc = "Smooth to the touch. You feel calmer with it in your palm.\n\nIncreases <#BLUE>{name.concept_focus_hit}</> <#RED>{name.concept_damage}</>.\n\n<#RED>{name_multiple.gem}</> can be set into <#RED>Weapons</> by {name.npc_blacksmith}.",
			--at the <#RED>{name.station_gems}</>, located near {name.npc_blacksmith}.",
			slotted_desc = "Increases <#BLUE>{name.concept_focus_hit}</> <#RED>{name.concept_damage}</>.",
		},

		crit_chance =
		{
			name = "Critical Chance {name.gem}",
			desc = "You can sense this {name.gem} judging you.\n\nIncreases <#RED>Critical Hit Chance</>.\n\n<#RED>{name_multiple.gem}</> can be set into <#RED>Weapons</> by {name.npc_blacksmith}.",
			--at the <#RED>{name.station_gems}</>, located near {name.npc_blacksmith}.",
			slotted_desc = "Increases <#RED>{name.powerdesc_critchance}</>.",
		},


		speed =
		{
			name = "Runspeed {name.gem}",
			desc = "You swear lightning crackles through it out the corner of your eye.\n\nIncreases <#RED>{name.concept_runspeed}</>.\n\n<#RED>{name_multiple.gem}</> can be set into <#RED>Weapons</> by {name.npc_blacksmith}.",
			--at the <#RED>{name.station_gems}</>, located near {name.npc_blacksmith}.",
			slotted_desc = "Increases <#RED>{name.concept_runspeed}</>.",
		},

		-- sprint =
		-- {
		-- 	name = "Sprint",
		-- 	desc = "{NAME.powerdesc_nopower}",
		-- },

		luck =
		{
			name = "Luck {name.gem}",
			desc = "You're not sure how, but you get the impression this {name.gem} is smiling.\n\nIncreases <#RED>Luck</>.\n\n<#RED>{name_multiple.gem}</> can be set into <#RED>Weapons</> by {name.npc_blacksmith}.",
			--at the <#RED>{name.station_gems}</>, located near {name.npc_blacksmith}.",
			slotted_desc = "Increases <#RED>Luck</>.",
		},

		max_health =
		{
			name = "Max Health {name.gem}",
			desc = "This thick-cut {name.gem} feels weighty in your hand.\n\nIncreases <#RED>Max Health</>.\n\n<#RED>{name_multiple.gem}</> can be set into <#RED>Weapons</> by {name.npc_blacksmith}.",
			--at the <#RED>{name.station_gems}</>, located near {name.npc_blacksmith}.",
			slotted_desc = "Increases <#RED>Max Health</>.",
		},

		bonus_damage_cabbageroll =
		{
			name = "{name.cabbageroll} Damage {name.gem}",
			desc = "it's a gem and it'll make you punch those bulbinses bettering heh dude",
			--at the <#RED>{name.station_gems}</>, located near {name.npc_blacksmith}.",
			slotted_desc = "Increases <#RED>{name.concept_damage}</> done to <#RED>{name_multiple.cabbageroll}</>.",
			stat_name = "Bonus <#RED>{name.concept_damage}</>",
		},
	},


	REWARDGROUPS =
	{
		common_powers =
		{
			name = "Common Powers",
			desc = "Part of default unlocks",
		},

		epic_powers =
		{
			name = "Epic Powers",
			desc = "Part of default unlocks",
		},

		legendary_powers =
		{
			name = "Legendary Powers",
			desc = "Part of default unlocks",
		},

		revive_powers =
		{
			name = "Revive Powers",
			desc = "Part of default unlocks",
		},

		-- Power Groups
		-- KRIS
		focus_powers =
		{
			name = "Focus Hit Powers",
			desc = "Get more bang for your buck from your ever-important <#BLUE>Focus Hits</>!",
		},
		hitstreak_powers =
		{
			name = "Hit Streak Powers",
			desc = "Maintain your <#RED>Hit Streak</> more effectively!",
		},
		hitstreak_2_powers =
		{
			name = "Hit Streak Powers",
			desc = "Build up your <#RED>Critical Chance</> to double your damage!",
		},
		weaponry_powers =
		{
			name = "Hit Streak Payoffs",
			desc = "Benefit from your <#RED>Hit Streak</>!",
		},
		onheal_powers =
		{
			name = "Healing Powers",
			desc = "Survive longer! Who needs Doc Hoggins?",
		},
		critchance_1_powers =
		{
			name = "Critical Chance Powers",
			desc = "Build up your <#RED>Critical Chance</> to double your damage!",
		},
		critproc_1_powers =
		{
			name = "Critical Hit Powers",
			desc = "More ways to build up and benefit from <#RED>Critical Chance</>!",
		},
		power_modifiers =
		{
			name = "Power Drop Modifiers",
			desc = "TODO",
		},
		gamechanger_powers =
		{
			name = "Gamechanger Powers",
			desc = "Fundamentally change what your gameplan is for big rewards!",
		},

		-- Dungeon Decor Drops
		treemon_forest_decor =
		{
			name = "{name.treemon_forest} Furniture",
			desc = "treemon_forest_decor desc",
		},
		owlitzer_forest_decor =
		{
			name = "{name.owlitzer_forest} Furniture",
			desc = "owlitzer_forest_decor desc",
		},
		bandi_swamp_decor =
		{
			name = "{name.bandi_swamp} Furniture",
			desc = "bandi_swamp_decor desc",
		},
		thatcher_swamp_decor =
		{
			name = "{name.thatcher_swamp} Furniture",
			desc = "thatcher_swamp_decor desc",
		},
	},
}

require "strings.strings_powers"
